//
//  AppDelegate.m
//  Creating and Managing Folders for Apps in iCloud
//
//  Created by Vandad Nahavandipoor on 21/08/2011.
//  Copyright (c) 2011 Pixolity Ltd. All rights reserved.
//

#import "AppDelegate.h"

@implementation AppDelegate

@synthesize window = _window;

/* 1 */
//- (BOOL)            application:(UIApplication *)application
//  didFinishLaunchingWithOptions:(NSDictionary *)launchOptions{
//  
//  NSFileManager *fileManager = [[NSFileManager alloc] init];
//  
//  /* Miejsce na Twój identyfikator Team ID. */
//  NSString *teamID = @"TEAM ID";
//  
//  NSString *rootFolderIdentifier = [NSString stringWithFormat:
//    @"%@.com.pixolity.Creating-and-Managing-Folders-for-Apps-in-iCloud",
//                                    teamID];
//  
//  NSURL *containerURL = 
//    [fileManager URLForUbiquityContainerIdentifier:rootFolderIdentifier];
//  
//  NSString *documentsDirectory = [[containerURL path] 
//                                  stringByAppendingPathComponent:@"Documents"];
//  BOOL isDirectory = NO;
//  BOOL mustCreateDocumentsDirectory = NO;
//  
//  if ([fileManager fileExistsAtPath:documentsDirectory
//                        isDirectory:&isDirectory]){
//    if (isDirectory == NO){
//      mustCreateDocumentsDirectory = YES;
//    }
//  } else {
//    mustCreateDocumentsDirectory = YES;
//  }
//  
//  if (mustCreateDocumentsDirectory){
//    NSLog(@"Trzeba utworzyć katalog.");
//    
//    NSError *directoryCreationError = nil;
//    
//    if ([fileManager createDirectoryAtPath:documentsDirectory
//               withIntermediateDirectories:YES
//                                attributes:nil
//                                     error:&directoryCreationError]){
//      NSLog(@"Udało się utworzyć katalog.");
//    } else {
//      NSLog(@"Nie udało się utworzyć katalogu z powodu błędu = %@", 
//            directoryCreationError);
//    }
//    
//  } else {
//    NSLog(@"Ten katalog już istnieje.");
//  }
//  
//  self.window = [[UIWindow alloc] initWithFrame:
//                 [[UIScreen mainScreen] bounds]];
//  
//  self.window.backgroundColor = [UIColor whiteColor];
//  [self.window makeKeyAndVisible];
//  return YES;
//}

/* 2 */
//- (BOOL) createiCloudDirectory:(NSString *)paramDirectory
//             recursiveCreation:(BOOL)paramRecursiveCreation
//                   teamID:(NSString *)paramTeamID
//               iCloudContainer:(NSString *)paramContainer
//                     finalPath:(NSString **)paramFinalPath{
//  
//  BOOL result = NO;
//  
//  NSFileManager *fileManager = [[NSFileManager alloc] init];
//  
//  NSString *rootFolderIdentifier = [NSString stringWithFormat:
//                                    @"%@.%@", paramTeamID, paramContainer];
//  
//  NSURL *containerURL = 
//    [fileManager URLForUbiquityContainerIdentifier:rootFolderIdentifier];
//  
//  NSString *documentsDirectory = [[containerURL path] 
//                                  stringByAppendingPathComponent:@"Documents"];
//  
//  if (paramFinalPath != nil){
//    *paramFinalPath = documentsDirectory;
//  }
//  
//  BOOL isDirectory = NO;
//  BOOL mustCreateDocumentsDirectory = NO;
//  
//  if ([fileManager fileExistsAtPath:documentsDirectory
//                        isDirectory:&isDirectory]){
//    if (isDirectory == NO){
//      mustCreateDocumentsDirectory = YES;
//    }
//  } else {
//    mustCreateDocumentsDirectory = YES;
//  }
//  
//  if (mustCreateDocumentsDirectory){
//    NSLog(@"Trzeba utworzyć katalog.");
//    
//    NSError *directoryCreationError = nil;
//    
//    if ([fileManager createDirectoryAtPath:documentsDirectory
//               withIntermediateDirectories:paramRecursiveCreation
//                                attributes:nil
//                                     error:&directoryCreationError]){
//      result = YES;
//      NSLog(@"Udało się utworzyć katalog.");
//    } else {
//      NSLog(@"Nie udało się utworzyć katalogu z powodu błędu = %@", 
//            directoryCreationError);
//    }
//    
//  } else {
//    NSLog(@"Ten katalog już istnieje.");
//    result = YES;
//  }
//  
//  return result;
//  
//}
//
//- (BOOL)            application:(UIApplication *)application
//didFinishLaunchingWithOptions:(NSDictionary *)launchOptions{
//  
//  
//  /* Miejsce na Twój identyfikator Team ID. */
//  NSString *teamID = @"TEAM ID";
//  
//  NSString *containerID = 
//  @"com.pixolity.Creating-and-Managing-Folders-for-Apps-in-iCloud";
//  
//  NSString *documentsDirectory = nil;
//  
//  if ([self createiCloudDirectory:@"Documents"
//                recursiveCreation:YES 
//                           teamID:teamID
//                  iCloudContainer:containerID
//                        finalPath:&documentsDirectory]){
//    NSLog(@"Udało się utworzyć katalog w %@", documentsDirectory);
//  } else {
//    NSLog(@"Nie udało się utworzyć katalogu.");
//  }
//  
//  self.window = [[UIWindow alloc] initWithFrame:
//                 [[UIScreen mainScreen] bounds]];
//  
//  self.window.backgroundColor = [UIColor whiteColor];
//  [self.window makeKeyAndVisible];
//  return YES;
//}


/* 3 */
- (BOOL) createiCloudDirectory:(NSString *)paramDirectory
             recursiveCreation:(BOOL)paramRecursiveCreation
                        teamID:(NSString *)paramTeamID
               iCloudContainer:(NSString *)paramContainer
                     finalPath:(NSString **)paramFinalPath{
  
  BOOL result = NO;
  
  NSFileManager *fileManager = [[NSFileManager alloc] init];
  
  NSString *rootFolderIdentifier = [NSString stringWithFormat:
                                    @"%@.%@", paramTeamID, paramContainer];
  
  NSURL *containerURL = 
  [fileManager URLForUbiquityContainerIdentifier:rootFolderIdentifier];
  
  NSString *documentsDirectory = [[containerURL path] 
                                  stringByAppendingPathComponent:@"Documents"];
  
  if (paramFinalPath != nil){
    *paramFinalPath = documentsDirectory;
  }
  
  BOOL isDirectory = NO;
  BOOL mustCreateDocumentsDirectory = NO;
  
  if ([fileManager fileExistsAtPath:documentsDirectory
                        isDirectory:&isDirectory]){
    if (isDirectory == NO){
      mustCreateDocumentsDirectory = YES;
    }
  } else {
    mustCreateDocumentsDirectory = YES;
  }
  
  if (mustCreateDocumentsDirectory){
    NSLog(@"Trzeba utworzyć katalog.");
    
    NSError *directoryCreationError = nil;
    
    if ([fileManager createDirectoryAtPath:documentsDirectory
               withIntermediateDirectories:paramRecursiveCreation
                                attributes:nil
                                     error:&directoryCreationError]){
      result = YES;
      NSLog(@"Udało się utworzyć katalog.");
    } else {
      NSLog(@"Nie udało się utworzyć katalogu z powodu błędu = %@", 
            directoryCreationError);
    }
    
  } else {
    NSLog(@"Ten katalog już istnieje.");
    result = YES;
  }
  
  return result;
  
}

- (BOOL)            application:(UIApplication *)application
  didFinishLaunchingWithOptions:(NSDictionary *)launchOptions{
  
  ///* Miejsce na Twój identyfikator Team ID. */
  NSString *teamID = @"";
  
  NSString *containerID = 
    @"com.pixolity.Creating-and-Managing-Folders-for-Apps-in-iCloud";
  
  NSString *documentsDirectory = nil;
  
  if ([self createiCloudDirectory:@"Documents"
            recursiveCreation:YES 
                       teamID:teamID
                  iCloudContainer:containerID
                        finalPath:&documentsDirectory]){
    NSLog(@"Udało się utworzyć katalog w %@", documentsDirectory);
    
    NSString *stringToSave = @"Mój ciąg tekstowy";
    
    NSString *pathToSave = [documentsDirectory 
                            stringByAppendingPathComponent:@"MyString.txt"];
    
    NSError *savingError = nil;
    
    if ([stringToSave writeToFile:pathToSave
                       atomically:YES
                         encoding:NSUTF8StringEncoding
                            error:&savingError]){
      NSLog(@"Udało się zapisać ciąg tekstowy w usłudze iCloud.");
    } else {
      NSLog(@"Nie udało się zapisać ciągu tekstowego z powodu błędu = %@", savingError);
    }
    
    
  } else {
    NSLog(@"Nie udało się utworzyć katalogu.");
  }
  
  self.window = [[UIWindow alloc] initWithFrame:
                 [[UIScreen mainScreen] bounds]];
  
  self.window.backgroundColor = [UIColor whiteColor];
  [self.window makeKeyAndVisible];
  return YES;
}

- (void)applicationWillResignActive:(UIApplication *)application
{
  /*
   Ta metoda jest wywoływana, gdy aplikacja przechodzi ze stanu aktywnego do nieaktywnego. Może być wywołana w określonych sytuacjach (na przykład w chwili odbywania rozmowy telefonicznej lub po otrzymaniu wiadomości SMS) bądź kiedy użytkownik kończy działanie aplikacji. Metoda rozpoczyna proces przejścia do stanu pozostania w tle. Tę metodę można wykorzystać do wstrzymania wykonywania bieżących zadań, wyłączenia liczników czasu, zmniejszenia liczby klatek generowanych przez OpenGL ES. W grach ta metoda powinna być użyta do wstrzymania gry (pauza).
   */
}

- (void)applicationDidEnterBackground:(UIApplication *)application
{
  /*
   Tę metodę należy wykorzystać do zwolnienia zasobów współdzielonych, zapisania danych użytkownika, wyzerowania liczników czasu oraz do przechowania takiej ilości informacji o stanie, która pozwoli na przywrócenie aplikacji do stanu bieżącego. Jeżeli aplikacja obsługuje działanie w tle, w chwili kończenia działania należy wywołać tę metodę zamiast applicationWillTerminate:.
   */
}

- (void)applicationWillEnterForeground:(UIApplication *)application
{
  /*
   Ta metoda jest wywoływana podczas przechodzenia aplikacji ze stanu aktywnego do działania w tle. Można więc tutaj wycofać wiele zmian wprowadzonych w chwili przechodzenia do stanu działania w tle.
   */
}

- (void)applicationDidBecomeActive:(UIApplication *)application
{
  /*
   W tej metodzie można wznowić działanie zadań zatrzymanych (lub nieuruchomionych), gdy aplikacja była nieaktywna. Jeżeli aplikacja znajdowała się w trybie działania w tle, w metodzie można przeprowadzić odświeżenie interfejsu użytkownika.
   */
}

- (void)applicationWillTerminate:(UIApplication *)application
{
  /*
   Ta metoda jest wywoływana, gdy działanie aplikacji ma zostać zakończone. Zapoznaj się z opisem metody applicationDidEnterBackground:.
   */
}

@end
